#!/usr/bin/env bash
screenshot_dir=screenshots_${BUILD_NUMBER}
script_name=$(basename -- "$0")
echo "EXECUTE SCRIPT: $script_name"
echo "$script_name : pwd"

echo "$script_name : ruby version: $(ruby -v)"

echo "$script_name : cd to veteran-appointment-requests/test/watir-ruby. (MUST do this for running tests properly)"
cd veteran-appointment-requests/test/watir-ruby
mkdir ${screenshot_dir}
chmod 777 ${screenshot_dir}
echo "$script_name : bundle install using default Gemfile"
bundle install --binstubs

echo "$script_name : Run selected rspec tests"
while read -r t || [[ -n "$t" ]]; do
    echo "$script_name : Running: $t"
    test_base_name=$(echo $t | awk -F/ '{print $NF}')
    echo "$script_name : DEBUG: Test base name: $test_base_name"
    bundle exec rspec $t --format html --out rspec_results-$test_base_name.html
done <selected-tests.txt

echo "$script_name : pwd"
pwd

echo "$script_name : List files in current dir"
ls -la

echo "$script_name : List files in screenshots dir"
ls -la ${screenshot_dir}

echo "$script_name : Move screenshots and results to archive to /out directory to be copied out and archived"
mv ${screenshot_dir}/* ../../../out/
mv rspec_results*.html ../../../out/

echo "$script_name : Trigger acceptance-test_status.sh running on Jenkins to copy out necessary files"
echo "Acceptance Tests Complete"